# This file has been autogenerated by the pywayland scanner

# Copyright © 2024 Neal Gompa
# Copyright © 2024 Xaver Hugl
# Copyright © 2024 Matthias Klumpp
# Copyright © 2024 Vlad Zahorodnii
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlPointer
from ..wayland import WlSurface


class WpPointerWarpV1(Interface):
    """Reposition the pointer to a location on a surface

    This global interface allows applications to request the pointer to be
    moved to a position relative to a
    :class:`~pywayland.protocol.wayland.WlSurface`.

    Note that if the desired behavior is to constrain the pointer to an area or
    lock it to a position, this protocol does not provide a reliable way to do
    that. The pointer constraint and pointer lock protocols should be used for
    those use cases instead.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "wp_pointer_warp_v1"
    version = 1


class WpPointerWarpV1Proxy(Proxy[WpPointerWarpV1]):
    interface = WpPointerWarpV1

    @WpPointerWarpV1.request()
    def destroy(self) -> None:
        """Destroy the warp manager

        Destroy the pointer warp manager.
        """
        self._marshal(0)
        self._destroy()

    @WpPointerWarpV1.request(
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlPointer),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Uint),
    )
    def warp_pointer(self, surface: WlSurface, pointer: WlPointer, x: float, y: float, serial: int) -> None:
        """Reposition the pointer

        Request the compositor to move the pointer to a surface-local position.
        Whether or not the compositor honors the request is implementation
        defined, but it should - honor it if the surface has pointer focus,
        including   when it has an implicit pointer grab - reject it if the
        enter serial is incorrect - reject it if the requested position is
        outside of the surface

        Note that the enter serial is valid for any surface of the client, and
        does not have to be from the surface the pointer is warped to.

        :param surface:
            surface to position the pointer on
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param pointer:
            the pointer that should be repositioned
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :param x:
        :type x:
            `ArgumentType.Fixed`
        :param y:
        :type y:
            `ArgumentType.Fixed`
        :param serial:
            serial number of the enter event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(1, surface, pointer, x, y, serial)


class WpPointerWarpV1Resource(Resource):
    interface = WpPointerWarpV1


class WpPointerWarpV1Global(Global):
    interface = WpPointerWarpV1


WpPointerWarpV1._gen_c()
WpPointerWarpV1.proxy_class = WpPointerWarpV1Proxy
WpPointerWarpV1.resource_class = WpPointerWarpV1Resource
WpPointerWarpV1.global_class = WpPointerWarpV1Global
